<?php
    if($_POST)
    {
		require_once('./api/validation.php'); 
	};
    
    require_once('./api/get_user_country.php');

?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <title>AfricaOne : Create Account</title>
	
	<link href="fonts/sfuid/style.css" rel="stylesheet">
	
    <!-- Bootstrap core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
	<link href="css/flags.css" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.min.css" rel="stylesheet">
	<link href="css/custom.css" rel="stylesheet">
	
	<script src="js/jquery.min.js"></script>
	
</head>

<body class="d-flex flex-column h-100">
    <div class="container">

        <div class="row">
			<div class="col-md-12">
			
				<p class="mt-3 mb-1"><img src="img/africa-one-logo.svg" alt="AfricaOne" title="AfricaOne" /></p>
				
			</div>

		</div>
		
		<div class="row">
			<div class="col-md-12">
				<div class="d-flex">
			
					<div class="card create-account-card">
						<div class="card-body">
						
							<div class="row">
								<div class="col-md-7">
									<h1 class="card-title mb-4">Create your Africa One Email</h1>

									<p class="validation-error" <?php if ($showDivFlag1===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $fnameErr ?> </p>
									<p class="validation-error" <?php if ($showDivFlag2===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $lnameErr ?> </p>
									<p class="validation-error" <?php if ($showDivFlag3===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $unameErr ?> </p>
									<p class="validation-error" <?php if ($showDivFlag4===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $pass1Err ?> </p>
									<p class="validation-error" <?php if ($showDivFlag5===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $pass2Err ?> </p>
									<p class="validation-error" <?php if ($showDivFlag6===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $passwordErr ?> </p>
									<p class="validation-error" <?php if ($showDivFlag7===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $phoneErr ?> </p>
									<p class="validation-error" <?php if ($showDivFlag8===true){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> <?php echo $emailErr ?> </p>

									
									<form action="create-account.php" method="POST">

									<div id="step-1">
										<div class="row mb-1">
											<div class="col-md-6">
												<div class="form-group">
													<label>First Name</label>
													<input type="text" class="form-control" placeholder="Enter First Name" aria-label="Enter First Name" name="firstname" value=<?php echo $_POST["firstname"] ?>>									</div>
											</div>
											
											<div class="col-md-6">
												<div class="form-group">
													<label>Last Name</label>
													<input type="text" class="form-control" placeholder="Enter Last Name" aria-label="Enter Last Name" name="lastname" value=<?php echo $_POST["lastname"] ?>>
												</div>
											</div>

										</div>
											

										<div class="row mb-1">
											<div class="col-md-12">
												<div class="form-group">
													<label>Username</label>
													<div class="input-group input-group-multiple">
														<input type="text" class="form-control" placeholder="Enter Your Email" aria-label="Enter Your Email" name="username" value=<?php echo $_POST["username"] ?>>
														<div class="input-group-append">
															<span class="input-group-text" id="basic-addon2">@africaone.com</span>
														</div>
													</div>
												</div>
												<!-- <p class="validation-error" <?php if ($showDivFlag===false){?>style="display:block"<?php } ?>><i class="fas fa-exclamation-circle"></i> That username is taken. Try another.</p> -->
											</div>
										</div>
										
										<div class="row mb-4">
											<div class="col-md-6">
												<div class="form-group">
													<label>Password</label>
													<input type="password" class="form-control" placeholder="Enter Password" aria-label="Enter Password" name="confirm_pass1">
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label>Confirm Password</label>
													<input type="password" class="form-control" placeholder="Confirm Password" aria-label="Confirm Password" name="confirm_pass2">
												</div>
											</div>
										</div>
										
										
										<div class="row mb-4">
											<div class="offset-md-6 col-md-6">
												<button type="button" class="btn btn-primary btn-block" id="next">Next</button>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12">
												<p class="text-center text-small">Already have an account? <a href="login.html" class="card-link">Sign in</a></p>
											</div>
										</div>
									</div>
									
		
									
									<div id="step-2" style="display:none;">
										<div class="row mb-1">
											<div class="col-md-12">
												<div class="form-group">
													<label>Phone Number</label>
													<div class="input-group input-group-flags">
														<div class="input-group-prepend">
															<div id="basic" data-input-name="country" name="country"></div>
														</div>
														<input type="text" class="form-control" placeholder="Enter Number Here" aria-label="Enter Number Here" name="phone_number" value=<?php echo $_POST["phone_number"] ?>>
													</div>
												</div>
											</div>
											


										</div>
											
											
										<div class="row mb-1">
											<div class="col-md-12">
												<label>Date of birth</label>
												<div class="input-group input-group-flags">
											
													
													<input type="text" class="form-control" placeholder="Day" aria-label="Day" name="dob_day" maxlength="2" value=<?php echo $_POST["dob_day"] ?>>

													<input type="text" class="form-control" placeholder="Month" aria-label="Month" name="dob_month" maxlength="2" value=<?php echo $_POST["dob_month"] ?>>

													<input type="text" class="form-control" placeholder="Year" aria-label="Year" name="dob_year" minlength="4" maxlength="4" value=<?php echo $_POST["dob_year"] ?>>
												</div>
											</div>
										</div>
										
										<div class="row mb-4">
											<div class="col-md-6">
												<div class="form-group">
													<label>Gender</label>
													<input type="text" class="form-control" placeholder="Gender (optional)" aria-label="Gender (optional)" name="gender">
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label>Recovery Email</label>
													<input type="text" class="form-control" placeholder="Recovery Email" aria-label="Recovery Email" name="recovery_email" value=<?php echo $_POST["recovery_email"] ?>>
												</div>
											</div>
										</div>
										
										<div class="row">
											<div class="col-md-12">
												<p class="text-center text-small">The <a href="#" class="card-link">Terms and Conditions</a> apply</p>
											</div>
										</div>
										<div class="row mb-4">
											<div class="offset-md-1 col-md-10">
												<button type="submit" class="btn btn-primary btn-block">I agree. Create my account now.</button>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12">
												<p class="text-center text-small">Already have an account? <a href="login.html" class="card-link">Sign in</a></p>
											</div>
										</div>
									</div>
									
								</div>

								</form>
								
								<div class="col-md-5 branding">
									<p class="text-center">
										<img src="img/logo-colors-big.png" alt="AfricaOne" title="AfricaOne" class="form-logo my-3" />
									</p>
									<p class="intro-text">
										Welcome to<br />
										<span class="brand-name">AfricaOne.com</span><br />
										Africa�s No.1 Online Platform!<br />
										News, Email, Business<br /> 
										and more!
									</p>
								</div>

							</div>
						
							
							
							
							
							
							
							
						</div>
					</div>
				</div>
			
			
			
				
			</div>

		</div>

        
    </div>

		
	<footer class="footer mt-auto py-3">
	
		<p class="photo-credit">
			<span class="photo-label">Photo of the day:</span><br />
			Women planting vegetables<br />
			Nakuru, Kenya<br />
		</p>
		<div class="container">
			<div class="row">
				<div class="col-lg-8 col-md-12">

					<p class="footer-menu">News - Email - Business - Reviews - Web Hosting - Synergy - Farming</p>

				</div>
				<div class="col-lg-4 col-md-12">
					<p class="footer-copyright">2019 AFRICAONE.COM</p>
				</div>
			</div>
		</div>
	</footer>
		
	
	
    <script src="js/bootstrap.bundle.min.js"></script>
	<script src="js/jquery.flagstrap.js"></script>
	
    <script>
		$('#basic').flagStrap({
                        selectedCountry: "DE"
                });
		
		$('#next').on('click', function(){
			$('#step-1').hide();
			$('#step-2').show();
		});
	</script>
</body>

</html>
