/*
 *  FlagStrap - v3.3.5
 *  A lightwieght jQuery plugin for creating Bootstrap 3 compatible country select boxes with flags.
 *  http://www.blazeworx.com/flagstrap
 *
 *  Made by Alex Carter
 *  Under MIT License
 */
(function ($) {

    var defaults = {
        buttonSize: "btn-md",
        buttonType: "btn-default",
        labelMargin: "10px",
        scrollable: true,
        scrollableHeight: "250px"
    };

    var countries = {
        "US": "+1",
		"CA": "+1",
		"RU": "+7",
		"KZ": "+7",
		"EG": "+20",
		"ZA": "+27",
		"GR": "+30",
		"NL": "+31",
		"BE": "+32",
		"FR": "+33",
		"ES": "+34",
		"HU": "+36",
		"IT": "+39",
		"RO": "+40",
		"CH": "+41",
		"AT": "+43",
		"GB": "+44",
		"DK": "+45",
		"SE": "+46",
		"NO": "+47",
		"SJ": "+47",
		"PL": "+48",
		"DE": "+49",
		"PE": "+51",
		"MX": "+52",
		"CU": "+53",
		"AR": "+54",
		"BR": "+55",
		"CL": "+56",
		"CO": "+57",
		"VE": "+58",
		"MY": "+60",
		"AU": "+61",
		"CX": "+61",
		"CC": "+61",
		"ID": "+62",
		"PH": "+63",
		"NZ": "+64",
		"PN": "+64",
		"SG": "+65",
		"TH": "+66",
		"JP": "+81",
		"KR": "+82",
		"VN": "+84",
		"CN": "+86",
		"TR": "+90",
		"IN": "+91",
		"PK": "+92",
		"AF": "+93",
		"LK": "+94",
		"MM": "+95",
		"IR": "+98",
		"SS": "+211",
		"MA": "+212",
		"EH": "+212",
		"DZ": "+213",
		"TN": "+216",
		"LY": "+218",
		"GM": "+220",
		"SN": "+221",
		"MR": "+222",
		"ML": "+223",
		"GN": "+224",
		"CI": "+225",
		"BF": "+226",
		"NE": "+227",
		"TG": "+228",
		"BJ": "+229",
		"MU": "+230",
		"LR": "+231",
		"SL": "+232",
		"GH": "+233",
		"NG": "+234",
		"TD": "+235",
		"CF": "+236",
		"CM": "+237",
		"CV": "+238",
		"ST": "+239",
		"GQ": "+240",
		"GA": "+241",
		"CG": "+242",
		"CD": "+243",
		"AO": "+244",
		"GW": "+245",
		"IO": "+246",
		"SC": "+248",
		"SD": "+249",
		"RW": "+250",
		"ET": "+251",
		"SO": "+252",
		"DJ": "+253",
		"KE": "+254",
		"TZ": "+255",
		"UG": "+256",
		"BI": "+257",
		"MZ": "+258",
		"ZM": "+260",
		"MG": "+261",
		"YT": "+262",
		"RE": "+262",
		"ZW": "+263",
		"NA": "+264",
		"MW": "+265",
		"LS": "+266",
		"BW": "+267",
		"SZ": "+268",
		"KM": "+269",
		"SH": "+290",
		"ER": "+291",
		"AW": "+297",
		"FO": "+298",
		"GL": "+299",
		"GI": "+350",
		"PT": "+351",
		"LU": "+352",
		"IE": "+353",
		"IS": "+354",
		"AL": "+355",
		"MT": "+356",
		"CY": "+357",
		"FI": "+358",
		"BG": "+359",
		"LT": "+370",
		"LV": "+371",
		"EE": "+372",
		"MD": "+373",
		"AM": "+374",
		"BY": "+375",
		"AD": "+376",
		"MC": "+377",
		"SM": "+378",
		"VA": "+379",
		"UA": "+380",
		"RS": "+381",
		"ME": "+382",
		"XK": "+383",
		"HR": "+385",
		"SI": "+386",
		"BA": "+387",
		"MK": "+389",
		"CZ": "+420",
		"SK": "+421",
		"LI": "+423",
		"FK": "+500",
		"BZ": "+501",
		"GT": "+502",
		"BZ": "+501",
		"GT": "+502",
		"SV": "+503",
		"HN": "+504",
		"NI": "+505",
		"CR": "+506",
		"PA": "+507",
		"PM": "+508",
		"HT": "+509",
		"BL": "+590",
		"MF": "+590",
		"BO": "+591",
		"GY": "+592",
		"EC": "+593",
		"PY": "+595",
		"SR": "+597",
		"UY": "+598",
		"CW": "+599",
		"AN": "+599",
		"TL": "+670",
		"AQ": "+672",
		"BN": "+673",
		"NR": "+674",
		"PG": "+675",
		"TO": "+676",
		"SB": "+677",
				"VU": "+678",
		"FJ": "+679",
		"PW": "+680",
		"WF": "+681",
		"CK": "+682",
		"NU": "+683",
		"WS": "+685",
		"KI": "+686",
		"NC": "+687",
		"TV": "+688",
		"PF": "+689",
		"TK": "+690",
		"FM": "+691",
		"MH": "+692",
		"BB": "+809",
		"BS": "+809",
		"AI": "+809",
		"BM": "+809",
		"VI": "+809",
		"KP": "+850",
		"HK": "+852",
		"MO": "+853",
		"KH": "+855",
		"LA": "+856",
		"BD": "+880",
		"TW": "+886",
		"MV": "+960",
		"LB": "+961",
		"JO": "+962",
		"SY": "+963",
		"IQ": "+964",
		"KW": "+965",
		"SA": "+966",
		"YE": "+967",
		"OM": "+968",
		"PS": "+970",
		"AE": "+971",
		"IL": "+972",
		"BH": "+973",
		"QA": "+974",
		"BT": "+975",
		"MN": "+976",
		"NP": "+977",
		"TJ": "+992",
		"TM": "+993",
		"AZ": "+994",
		"GE": "+995",
		"KG": "+996",
		"UZ": "+998",
    };
    $.flagStrap = function (element, options, i) {

        var plugin = this;

        var uniqueId = generateId(8);

        plugin.countries = {};
        plugin.selected = {value: null, text: null};
        plugin.settings = {inputName: 'country-' + uniqueId};

        var $container = $(element);
        var htmlSelectId = 'flagstrap-' + uniqueId;
        var htmlSelect = '#' + htmlSelectId;

        plugin.init = function () {

            // Merge in global settings then merge in individual settings via data attributes
            plugin.countries = countries;

            // Initialize Settings, priority: defaults, init options, data attributes
            plugin.countries = countries;
            plugin.settings = $.extend({}, defaults, options, $container.data());

            if (undefined !== plugin.settings.countries) {
                plugin.countries = plugin.settings.countries;
            }

            // Build HTML Select, Construct the drop down button, Assemble the drop down list items element and insert
            $container
                .addClass('flagstrap')
                .append(buildHtmlSelect)
                .append(buildDropDownButton)
                .append(buildDropDownButtonItemList);

            // Hide the actual HTML select
            $(htmlSelect).hide();

        };

        var buildHtmlSelect = function () {
            var htmlSelectElement = $('<select/>').attr('id', htmlSelectId).attr('name', plugin.settings.inputName);

            $.each(plugin.countries, function (code, country) {
                var optionAttributes = {value: code};
                if (plugin.settings.selectedCountry !== undefined) {
                    if (plugin.settings.selectedCountry === code) {
                        optionAttributes = {value: code, selected: "selected"};
                        plugin.selected = {value: code, text: country}
                    }
                }
                htmlSelectElement.append($('<option>', optionAttributes).text(country));
            });

            return htmlSelectElement;
        };

        var buildDropDownButton = function () {

            var selectedText = $(htmlSelect).find('option').first().text();
            var selectedValue = $(htmlSelect).find('option').first().val();

            selectedText = plugin.selected.text || selectedText;
            selectedValue = plugin.selected.value || selectedValue;

            var $selectedLabel = $('<i/>').addClass('flagstrap-icon flagstrap-' + selectedValue.toLowerCase()).css('margin-right', plugin.settings.labelMargin);

            var buttonLabel = $('<span/>')
                .addClass('flagstrap-selected-' + uniqueId)
                .html($selectedLabel)
                .append(selectedText);

            var button = $('<button/>')
                .attr('data-toggle', 'dropdown')
                .attr('id', 'flagstrap-drop-down-' + uniqueId)
                .addClass('btn ' + plugin.settings.buttonType + ' ' + plugin.settings.buttonSize + ' dropdown-toggle')
                .html(buttonLabel);

            $('<span/>')
                .addClass('caret')
                .css('margin-left', plugin.settings.labelMargin)
                .insertAfter(buttonLabel);

            return button;

        };

        var buildDropDownButtonItemList = function () {
            var items = $('<ul/>')
                .attr('id', 'flagstrap-drop-down-' + uniqueId + '-list')
                .attr('aria-labelled-by', 'flagstrap-drop-down-' + uniqueId)
                .addClass('dropdown-menu');

            if (plugin.settings.scrollable) {
                items.css('height', 'auto')
                    .css('max-height', plugin.settings.scrollableHeight)
                    .css('overflow-x', 'hidden');
            }

            // Populate the bootstrap dropdown item list
            $(htmlSelect).find('option').each(function () {

                // Get original select option values and labels
                var text = $(this).text();
                var value = $(this).val();

                // Build the flag icon
                var flagIcon = $('<i/>').addClass('flagstrap-icon flagstrap-' + value.toLowerCase()).css('margin-right', plugin.settings.labelMargin);

                // Build a clickable drop down option item, insert the flag and label, attach click event
                var flagStrapItem = $('<a/>')
                    .attr('data-val', $(this).val())
                    .html(flagIcon)
                    .append(text)
                    .on('click', function (e) {
                        $(htmlSelect).find('option').removeAttr('selected');
                        $(htmlSelect).find('option[value="' + $(this).data('val') + '"]').attr("selected", "selected");
                        $('.flagstrap-selected-' + uniqueId).html($(this).html());
                        e.preventDefault();
                    });

                // Make it a list item
                var listItem = $('<li/>').prepend(flagStrapItem);

                // Append it to the drop down item list
                items.append(listItem);

            });

            return items;
        };

        function generateId(length) {
            var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz'.split('');

            if (!length) {
                length = Math.floor(Math.random() * chars.length);
            }

            var str = '';
            for (var i = 0; i < length; i++) {
                str += chars[Math.floor(Math.random() * chars.length)];
            }
            return str;
        }

        plugin.init();

    };

    $.fn.flagStrap = function (options) {

        return this.each(function (i) {
            if ($(this).data('flagStrap') === undefined) {
                $(this).data('flagStrap', new $.flagStrap(this, options, i));
            }
        });

    }

})(jQuery);