<?php 

function test_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
  }
  
$nameErr = $emailErr = $genderErr = $websiteErr = "";
$fname = $password1 = $password2 = $email = $gender = $comment = $website = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
if (empty($_POST["firstname"])) {
$fnameErr = "first name is required";
$showDivFlag1=true;
} else {
$fname = test_input($_POST["firstname"]);
// verify input
if (!preg_match("/^[a-zA-Z]*$/",$fname)) {
  $fnameErr = "Only letters allowed in firstname"; 
  $showDivFlag1=true;
}
}

if (empty($_POST["lastname"])) {
$lnameErr = "last name is required";
$showDivFlag2=true;
} else {
$name = test_input($_POST["lastname"]);
// verify input
if (!preg_match("/^[a-zA-Z]*$/",$name)) {
  $lnameErr = "Only letters allowed in lastname";
  $showDivFlag2=true; 
}
}

if (empty($_POST["username"])) {
$unameErr = "username is required";
$showDivFlag3=true;
} else {
$name = test_input($_POST["username"]);
// verify input
if (!preg_match("/^[a-zA-Z0-9._]*$/",$name)) {
  $unameErr = "Only letters , numbers and . or _ allowed in username";
  $showDivFlag3=true; 
}
}

if (empty($_POST["confirm_pass1"])) {
$pass1Err = "password is required";
$showDivFlag4=true;
} else {
$password1 = $_POST["confirm_pass1"];
// verify input
if (!preg_match("#.*^(?=.{8,20})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*\W).*$#", $password1 )) {
  $pass1Err = "password must be at least 8 characters long with at least one digit, one upper case letter, one lower case letter and one special symbol";
  $showDivFlag4=true; 
}
}

if (empty($_POST["confirm_pass2"])) {
$pass2Err = "confirm password is required";
$showDivFlag5=true;
} else {
$password2 = $_POST["confirm_pass2"];
// verify input
if (!preg_match("#.*^(?=.{8,20})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*\W).*$#", $password2 )){
  $pass2Err = "password must be at least 8 characters long with at least one digit, one upper case letter, one lower case letter and one special symbol"; 
  $showDivFlag5=true;
}
}

if ($_POST['confirm_pass1']!= $_POST['confirm_pass2']) {
  $passwordErr = "passwords do not match";
  $showDivFlag6=true;
}

if (empty($_POST["phone_number"])) {
$phoneErr = "phone number is required";
$showDivFlag7=true;
} else {
$name = test_input($_POST["phone_number"]);
// verify input
if (!preg_match("/^[0-9]*$/",$name)) {
  $phoneErr = "Only numbers allowed in phone number"; 
  $showDivFlag7=true;
}
}

if (empty($_POST["recovery_email"])) {
$emailErr = "Recovery Email is required";
$showDivFlag8=true;
} else {
$email = test_input($_POST["recovery_email"]);
// check if e-mail address is well-formed
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  $emailErr = "Invalid recovery email format";
  $showDivFlag8=true; 
}
}

if (empty($_POST["gender"])) {
$genderErr = "Gender is required";
} else {
$gender = test_input($_POST["gender"]);
}
}

if(!$fnameErr && !$lnameErr && !$unameErr && !$pass1Err && !$pass2Err && !$passwordErr && !$phoneErr && !$emailErr)
{
    require_once('./api/db_connection.php'); 
};

?>
